<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFulfillmentEventsTable extends Migration {

	public function up()
	{
		Schema::create('fulfillment_events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('fulfillment_id');
			$table->enum('type', array('pickup', 'dropoff', 'customer_missed_pickup', 'driver_missed_pickup'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('fulfillment_events');
	}
}