<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pupils', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('staff_members', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('sublocation_id')->references('id')->on('sublocations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('competencies', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('planned_lesson', function(Blueprint $table) {
			$table->foreign('lesson_type_id')->references('id')->on('lesson_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('planned_lesson', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pupil_lesson_registration', function(Blueprint $table) {
			$table->foreign('planned_lesson_id')->references('id')->on('planned_lesson')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pupil_lesson_registration', function(Blueprint $table) {
			$table->foreign('pupil_id')->references('id')->on('pupils')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pupil_lesson_registration', function(Blueprint $table) {
			$table->foreign('course_product_id')->references('id')->on('subscriptions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('pupil_lesson_registration')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->foreign('scored_by')->references('id')->on('staff_members')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sublocations', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('course_planned_lesson', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_planned_lesson', function(Blueprint $table) {
			$table->foreign('planned_lesson_id')->references('id')->on('planned_lesson')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_pupil', function(Blueprint $table) {
			$table->foreign('pupil_id')->references('id')->on('pupils')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_pupil', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('staff_member_lesson_registration', function(Blueprint $table) {
			$table->foreign('planned_lesson_id')->references('id')->on('planned_lesson')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('staff_member_lesson_registration', function(Blueprint $table) {
			$table->foreign('staff_member_id')->references('id')->on('staff_members')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pupils', function(Blueprint $table) {
			$table->dropForeign('pupils_customer_id_foreign');
		});
		Schema::table('staff_members', function(Blueprint $table) {
			$table->dropForeign('staff_members_user_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_location_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_sublocation_id_foreign');
		});
		Schema::table('competencies', function(Blueprint $table) {
			$table->dropForeign('competencies_course_id_foreign');
		});
		Schema::table('planned_lesson', function(Blueprint $table) {
			$table->dropForeign('planned_lesson_lesson_type_id_foreign');
		});
		Schema::table('planned_lesson', function(Blueprint $table) {
			$table->dropForeign('planned_lesson_section_id_foreign');
		});
		Schema::table('pupil_lesson_registration', function(Blueprint $table) {
			$table->dropForeign('pupil_lesson_registration_planned_lesson_id_foreign');
		});
		Schema::table('pupil_lesson_registration', function(Blueprint $table) {
			$table->dropForeign('pupil_lesson_registration_pupil_id_foreign');
		});
		Schema::table('pupil_lesson_registration', function(Blueprint $table) {
			$table->dropForeign('pupil_lesson_registration_course_product_id_foreign');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->dropForeign('lesson_scores_lesson_id_foreign');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->dropForeign('lesson_scores_scored_by_foreign');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->dropForeign('lesson_scores_created_by_foreign');
		});
		Schema::table('lesson_scores', function(Blueprint $table) {
			$table->dropForeign('lesson_scores_updated_by_foreign');
		});
		Schema::table('sublocations', function(Blueprint $table) {
			$table->dropForeign('sublocations_location_id_foreign');
		});
		Schema::table('course_planned_lesson', function(Blueprint $table) {
			$table->dropForeign('course_planned_lesson_course_id_foreign');
		});
		Schema::table('course_planned_lesson', function(Blueprint $table) {
			$table->dropForeign('course_planned_lesson_planned_lesson_id_foreign');
		});
		Schema::table('course_pupil', function(Blueprint $table) {
			$table->dropForeign('course_pupil_pupil_id_foreign');
		});
		Schema::table('course_pupil', function(Blueprint $table) {
			$table->dropForeign('course_pupil_course_id_foreign');
		});
		Schema::table('staff_member_lesson_registration', function(Blueprint $table) {
			$table->dropForeign('staff_member_lesson_registration_planned_lesson_id_foreign');
		});
		Schema::table('staff_member_lesson_registration', function(Blueprint $table) {
			$table->dropForeign('staff_member_lesson_registration_staff_member_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_user_id_foreign');
		});
	}
}