<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PlannedLesson extends Eloquent {

	protected $table = 'planned_lesson';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function staffMembers()
	{
		return $this->hasMany('StaffMemberLessonRegistration');
	}

	public function section()
	{
		return $this->hasOne('Section');
	}

	public function courses()
	{
		return $this->hasMany('CoursePlannedLessonPivot');
	}

	public function lessonType()
	{
		return $this->hasOne('LessonType');
	}

}