<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pupil extends Eloquent {

	protected $table = 'pupils';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function registered_courses()
	{
		return $this->hasMany('CoursePupilPivot');
	}

}