<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('group', function(Blueprint $table) {
			$table->foreign('cover_photo')->references('id')->on('photo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item', function(Blueprint $table) {
			$table->foreign('memberId')->references('id')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('video', function(Blueprint $table) {
			$table->foreign('postId')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('video', function(Blueprint $table) {
			$table->foreign('eventId')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('video', function(Blueprint $table) {
			$table->foreign('itemId')->references('id')->on('item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photo', function(Blueprint $table) {
			$table->foreign('postId')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photo', function(Blueprint $table) {
			$table->foreign('eventId')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photo', function(Blueprint $table) {
			$table->foreign('itemId')->references('id')->on('item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file', function(Blueprint $table) {
			$table->foreign('postId')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file', function(Blueprint $table) {
			$table->foreign('eventId')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file', function(Blueprint $table) {
			$table->foreign('itemId')->references('id')->on('item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->foreign('memberId')->references('id')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('member', function(Blueprint $table) {
			$table->foreign('joinedBy')->references('id')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('member', function(Blueprint $table) {
			$table->foreign('userId')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user-group', function(Blueprint $table) {
			$table->foreign('userId')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user-group', function(Blueprint $table) {
			$table->foreign('groupId')->references('id')->on('group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('memberId')->references('id')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('memberId')->references('id')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('postId')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->foreign('memberId')->references('id')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->foreign('commentId')->references('id')->on('comment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->foreign('photoId')->references('id')->on('photo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->foreign('videoId')->references('id')->on('video')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('group', function(Blueprint $table) {
			$table->dropForeign('group_cover_photo_foreign');
		});
		Schema::table('item', function(Blueprint $table) {
			$table->dropForeign('item_memberId_foreign');
		});
		Schema::table('video', function(Blueprint $table) {
			$table->dropForeign('video_postId_foreign');
		});
		Schema::table('video', function(Blueprint $table) {
			$table->dropForeign('video_eventId_foreign');
		});
		Schema::table('video', function(Blueprint $table) {
			$table->dropForeign('video_itemId_foreign');
		});
		Schema::table('photo', function(Blueprint $table) {
			$table->dropForeign('photo_postId_foreign');
		});
		Schema::table('photo', function(Blueprint $table) {
			$table->dropForeign('photo_eventId_foreign');
		});
		Schema::table('photo', function(Blueprint $table) {
			$table->dropForeign('photo_itemId_foreign');
		});
		Schema::table('file', function(Blueprint $table) {
			$table->dropForeign('file_postId_foreign');
		});
		Schema::table('file', function(Blueprint $table) {
			$table->dropForeign('file_eventId_foreign');
		});
		Schema::table('file', function(Blueprint $table) {
			$table->dropForeign('file_itemId_foreign');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->dropForeign('event_memberId_foreign');
		});
		Schema::table('member', function(Blueprint $table) {
			$table->dropForeign('member_joinedBy_foreign');
		});
		Schema::table('member', function(Blueprint $table) {
			$table->dropForeign('member_userId_foreign');
		});
		Schema::table('user-group', function(Blueprint $table) {
			$table->dropForeign('user-group_userId_foreign');
		});
		Schema::table('user-group', function(Blueprint $table) {
			$table->dropForeign('user-group_groupId_foreign');
		});
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_memberId_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_memberId_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_postId_foreign');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->dropForeign('emoji_memberId_foreign');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->dropForeign('emoji_commentId_foreign');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->dropForeign('emoji_photoId_foreign');
		});
		Schema::table('emoji', function(Blueprint $table) {
			$table->dropForeign('emoji_videoId_foreign');
		});
	}
}