<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('user_type');
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('city_id');
			$table->text('address');
			$table->text('bio');
			$table->boolean('is_active');
			$table->bigInteger('latest_update_id')->unsigned()->nullable();
			$table->string('password');
			$table->string('facebook_id');
			$table->string('google_id');
			$table->bigInteger('role_id')->unsigned()->nullable();
			$table->string('multi_image');
			$table->string('verfiy_code');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}