<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('articulo_destino', function(Blueprint $table) {
			$table->foreign('destino_id')->references('id')->on('destino')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulo_destino', function(Blueprint $table) {
			$table->foreign('articulo_id')->references('id')->on('articulo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remito', function(Blueprint $table) {
			$table->foreign('proveedor_id')->references('id')->on('proveedor')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remito', function(Blueprint $table) {
			$table->foreign('destino_id')->references('id')->on('destino')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remito', function(Blueprint $table) {
			$table->foreign('orden_compra_id')->references('id')->on('orden_compra')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orden_compra', function(Blueprint $table) {
			$table->foreign('proveedor_id')->references('id')->on('proveedor')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('detalle_factura', function(Blueprint $table) {
			$table->foreign('factura_id')->references('id')->on('factura')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('detalle_oc', function(Blueprint $table) {
			$table->foreign('orden_compra_id')->references('id')->on('orden_compra')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('detalle_remito', function(Blueprint $table) {
			$table->foreign('remito_id')->references('id')->on('remito')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orden_pago', function(Blueprint $table) {
			$table->foreign('proveedor_id')->references('id')->on('proveedor')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orden_pago', function(Blueprint $table) {
			$table->foreign('factura_id')->references('id')->on('factura')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orden_pago_factura', function(Blueprint $table) {
			$table->foreign('orden_pago_id')->references('id')->on('orden_pago')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orden_pago_factura', function(Blueprint $table) {
			$table->foreign('factura_id')->references('id')->on('factura')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factura', function(Blueprint $table) {
			$table->foreign('orden_compra_id')->references('id')->on('orden_compra')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('articulo_destino', function(Blueprint $table) {
			$table->dropForeign('articulo_destino_destino_id_foreign');
		});
		Schema::table('articulo_destino', function(Blueprint $table) {
			$table->dropForeign('articulo_destino_articulo_id_foreign');
		});
		Schema::table('remito', function(Blueprint $table) {
			$table->dropForeign('remito_proveedor_id_foreign');
		});
		Schema::table('remito', function(Blueprint $table) {
			$table->dropForeign('remito_destino_id_foreign');
		});
		Schema::table('remito', function(Blueprint $table) {
			$table->dropForeign('remito_orden_compra_id_foreign');
		});
		Schema::table('orden_compra', function(Blueprint $table) {
			$table->dropForeign('orden_compra_proveedor_id_foreign');
		});
		Schema::table('detalle_factura', function(Blueprint $table) {
			$table->dropForeign('detalle_factura_factura_id_foreign');
		});
		Schema::table('detalle_oc', function(Blueprint $table) {
			$table->dropForeign('detalle_oc_orden_compra_id_foreign');
		});
		Schema::table('detalle_remito', function(Blueprint $table) {
			$table->dropForeign('detalle_remito_remito_id_foreign');
		});
		Schema::table('orden_pago', function(Blueprint $table) {
			$table->dropForeign('orden_pago_proveedor_id_foreign');
		});
		Schema::table('orden_pago', function(Blueprint $table) {
			$table->dropForeign('orden_pago_factura_id_foreign');
		});
		Schema::table('orden_pago_factura', function(Blueprint $table) {
			$table->dropForeign('orden_pago_factura_orden_pago_id_foreign');
		});
		Schema::table('orden_pago_factura', function(Blueprint $table) {
			$table->dropForeign('orden_pago_factura_factura_id_foreign');
		});
		Schema::table('factura', function(Blueprint $table) {
			$table->dropForeign('factura_orden_compra_id_foreign');
		});
	}
}