<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Division extends Eloquent {

	protected $table = 'divisions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'gender');

	public function athletes()
	{
		return $this->hasMany('App\Models\Athlete');
	}

	public function trainers()
	{
		return $this->belongsToMany('App\Models\Trainer');
	}

}