<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Trainer extends Eloquent {

	protected $table = 'trainers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lastname', 'date_of_birth', 'image', 'status', 'slug', 'training_id');

	public function athletes()
	{
		return $this->belongsToMany('App\Models\Athlete');
	}

	public function trainings()
	{
		return $this->hasMany('App\Models\Training');
	}

	public function disciplines()
	{
		return $this->belongsToMany('App\Models\Discipline');
	}

	public function divisions()
	{
		return $this->belongsToMany('App\Models\Division');
	}

}