<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('id')->references('user_id')->on('role_user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->foreign('slot_template')->references('id')->on('slot_templates')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('slot', function(Blueprint $table) {
			$table->foreign('slot_template')->references('id')->on('slot_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('slot', function(Blueprint $table) {
			$table->foreign('type_plane')->references('id')->on('slot_details')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sign_up', function(Blueprint $table) {
			$table->foreign('mission_id')->references('id')->on('missions')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('sign_up', function(Blueprint $table) {
			$table->foreign('slot_id')->references('id')->on('slot')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->dropForeign('missions_slot_template_foreign');
		});
		Schema::table('slot', function(Blueprint $table) {
			$table->dropForeign('slot_slot_template_foreign');
		});
		Schema::table('slot', function(Blueprint $table) {
			$table->dropForeign('slot_type_plane_foreign');
		});
		Schema::table('sign_up', function(Blueprint $table) {
			$table->dropForeign('sign_up_mission_id_foreign');
		});
		Schema::table('sign_up', function(Blueprint $table) {
			$table->dropForeign('sign_up_slot_id_foreign');
		});
	}
}