<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function menus()
	{
		return $this->belongsToMany('App\Menu');
	}

	public function products()
	{
		return $this->hasManyThrough('App\Product', 'App\Subcategory');
	}

	public function subcategories()
	{
		return $this->hasMany('App\Subcategory');
	}

}