<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventFactsInvolvementTable extends Migration {

	public function up()
	{
		Schema::create('event_facts_involvement', function(Blueprint $table) {
			$table->bigInteger('event_facts_id')->unsigned();
			$table->bigInteger('involvement_id')->unsigned();
			$table->integer('credits');
			$table->integer('preparation_hours');
			$table->string('involvement_qr', 256)->unique();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('event_facts_involvement');
	}
}