<?php

namespace App\Models\Activities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Activity extends Eloquent {

	protected $table = 'activities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getInstitution()
	{
		return $this->belongsTo('Institution');
	}

	public function getUser()
	{
		return $this->belongsTo('User');
	}

	public function getChallengeElements()
	{
		return $this->hasMany('ChallengeElement');
	}

	public function getAttendances()
	{
		return $this->hasMany('Attandance');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('Keyword', 'activity_keyword');
	}

	public function getEpisodeType()
	{
		return $this->belongsTo('EpisodeType');
	}

	public function getInvolvement()
	{
		return $this->belongsTo('Involvement');
	}

}