<?php

namespace App\Models\Students;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attandance extends Eloquent {

	protected $table = 'attendances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('state', 'max_creadits');

	public function getActionFacts()
	{
		return $this->belongsTo('EventFacts');
	}

	public function getStudent()
	{
		return $this->belongsTo('Student');
	}

	public function getActionRealization()
	{
		return $this->belongsTo('EventRealization');
	}

	public function getChallenge()
	{
		return $this->belongsTo('Challenge');
	}

	public function getQuiz()
	{
		return $this->belongsTo('Quiz');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('Keyword', 'att_keyword', 'attendance_id', 'keyword_id');
	}

	public function getActivity()
	{
		return $this->belongsTo('Activity');
	}

}