<?php

namespace App\Models\Students;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getStudents()
	{
		return $this->belongsToMany('Student', 'student_group');
	}

	public function getOwnerStudent()
	{
		return $this->belongsTo('Student', 'owner_student_id');
	}

	public function getOwnerUser()
	{
		return $this->belongsTo('User', 'owner_user_id');
	}

}