<?php

namespace App\Models\Quizes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quiz extends Eloquent {

	protected $table = 'quizes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getInstitution()
	{
		return $this->belongsTo('Institution');
	}

	public function getUser()
	{
		return $this->belongsTo('User');
	}

	public function getChallengeElements()
	{
		return $this->hasMany('ChallengeElement');
	}

	public function getAccreditation()
	{
		return $this->hasOne('Accreditation');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('Keyword', 'quiz_keyword');
	}

	public function getAttendances()
	{
		return $this->hasMany('Attandance');
	}

	public function getEpisodeType()
	{
		return $this->belongsTo('EpisodeType');
	}

	public function getInvolvement()
	{
		return $this->belongsTo('Involvement');
	}

}