<?php

namespace request;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'Request';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->hasOne('Customer', 'customer');
	}

	public function department()
	{
		return $this->hasOne('Department', 'department');
	}

}