<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Race extends Eloquent {

	protected $table = 'races';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function track()
	{
		return $this->belongsTo('Track', 'track_id');
	}

	public function drivers()
	{
		return $this->hasMany('Driver');
	}

}