<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvaluationSurveysByEvaluationSubclassTable extends Migration {

	public function up()
	{
		Schema::create('evaluation_surveys_by_evaluation_subclass', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->string('evaluation_subclass_code', 20)->primary();
			$table->tinyInteger('aggregated_unit_classify')->primary();
			$table->string('aggregated_unit_name', 200)->primary();
			$table->string('evaluation_subclass_name', 100);
			$table->float('score', 5,2)->nullable();
			$table->float('average_point', 5,2)->nullable();
			$table->string('evaluation_class_code', 20);
			$table->timestamps();
			$table->datetime('deleted_at');
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('evaluation_surveys_by_evaluation_subclass');
	}
}