<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvaluationRanksTable extends Migration {

	public function up()
	{
		Schema::create('evaluation_ranks', function(Blueprint $table) {
			$table->string('evaluation_rank', 2)->primary();
			$table->string('evaluation_main_rank', 1);
			$table->float('min_score', 5,2);
			$table->float('max_score', 5,2);
			$table->tinyInteger('emphasized_display_flag');
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('evaluation_ranks');
	}
}