<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionListsSurveysTable extends Migration {

	public function up()
	{
		Schema::create('question_lists_surveys', function(Blueprint $table) {
			$table->timestamps();
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->string('email_address');
			$table->string('question_code', 20);
			$table->string('question_subclass_code', 20);
			$table->string('evaluation_subclass_code', 20);
			$table->string('question_content', 200);
			$table->string('question_type', 20);
			$table->text('answer_result');
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('question_lists_surveys');
	}
}