<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImprovementActivityThemesTable extends Migration {

	public function up()
	{
		Schema::create('improvement_activity_themes', function(Blueprint $table) {
			$table->timestamps();
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->tinyInteger('theme_number')->primary();
			$table->string('theme_name', 200)->nullable();
			$table->datetime('complete_date')->nullable();
			$table->datetime('remind_date')->nullable();
			$table->text('plan')->nullable();
			$table->text('do')->nullable();
			$table->text('check')->nullable();
			$table->text('action')->nullable();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('improvement_activity_themes');
	}
}