<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessTypeInfosTable extends Migration {

	public function up()
	{
		Schema::create('business_type_infos', function(Blueprint $table) {
			$table->smallInteger('year')->primary();
			$table->integer('business_type_id')->primary();
			$table->integer('min_number_employee')->primary();
			$table->integer('max_number_employee')->primary();
			$table->float('revenue', 5,2);
			$table->bigInteger('operating_profit_graph_max_value');
			$table->bigInteger('operating_profit_graph_min_value');
			$table->bigInteger('operating_profit_avg');
			$table->bigInteger('normal_profit_graph_max_value');
			$table->bigInteger('normal_profit_graph_min_value');
			$table->bigInteger('normal_profit_avg');
			$table->bigInteger('cf_matrix_max_value');
			$table->bigInteger('cf_matrix_min_value');
			$table->bigInteger('cf_operation');
			$table->bigInteger('cf_investment');
			$table->bigInteger('cf_finance');
			$table->bigInteger('cf_free');
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('business_type_infos');
	}
}