<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyUsageStatusOfSystemsTable extends Migration {

	public function up()
	{
		Schema::create('company_usage_status_of_systems', function(Blueprint $table) {
			$table->timestamps();
			$table->string('company_id', 7)->primary();
			$table->smallInteger('usage_time')->primary();
			$table->tinyInteger('do_qc_survey_flag');
			$table->integer('total_send');
			$table->integer('total_answer');
			$table->float('answer_rate', 5,2);
			$table->float('amount_request', 5,2);
			$table->datetime('expected_time_payment');
			$table->tinyInteger('payment_confirmation_flag')->default('0');
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('company_usage_status_of_systems');
	}
}