<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationLogsTable extends Migration {

	public function up()
	{
		Schema::create('operation_logs', function(Blueprint $table) {
			$table->increments('operation_log_id');
			$table->timestamps();
			$table->tinyInteger('operator_role');
			$table->string('operator_email');
			$table->string('operator_id');
			$table->string('operator_first_name', 40);
			$table->string('operator_last_name', 40);
			$table->string('company_id', 7);
			$table->datetime('operation_time');
			$table->string('screen');
			$table->string('screen_action');
			$table->string('operation_type');
			$table->text('operation_detail');
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('operation_logs');
	}
}