<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSurveySchedulesTable extends Migration {

	public function up()
	{
		Schema::create('survey_schedules', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->datetime('first_send_at')->nullable();
			$table->datetime('remind_at')->nullable();
			$table->datetime('deadline_at')->nullable();
			$table->tinyInteger('survey_type');
			$table->integer('qc_survey_number')->nullable();
			$table->tinyInteger('cycle_handle_priority_task')->nullable();
			$table->integer('priority_task_schedule_number')->nullable();
			$table->string('priority_task_question_code', 7)->nullable();
			$table->tinyInteger('sending_status');
			$table->integer('total_send')->nullable();
			$table->integer('total_answer')->nullable();
			$table->float('answer_rate', 5,2)->nullable();
			$table->integer('price')->nullable();
			$table->integer('payment_money')->nullable();
			$table->float('score', 5,2)->nullable();
			$table->string('evaluation_rank', 2)->nullable();
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('survey_schedules');
	}
}