<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConExpertsTable extends Migration {

	public function up()
	{
		Schema::create('con_experts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('level_id');
			$table->integer('expertNum');
			$table->string('nationalCode', 10);
			$table->string('idNo', 10);
			$table->string('phone', 15);
			$table->string('temp_mobile', 128);
			$table->string('postalCode', 20);
			$table->string('address', 500);
			$table->string('alt_department_ids', 150)->nullable();
			$table->bigInteger('signature_file_id')->nullable();
			$table->string('uploadedFilesIDs', 120);
			$table->enum('experimentalPeriod', array('yes', 'no'));
			$table->tinyInteger('status');
			$table->tinyInteger('subStatus');
			$table->decimal('maxPrice', 15,0);
			$table->tinyInteger('voice_call')->nullable()->default('1');
			$table->tinyInteger('reserve_call')->nullable()->default('1');
			$table->tinyInteger('firstActivated')->nullable()->default('1');
			$table->enum('conditionsAgree', array('yes', 'no'));
			$table->integer('introduction')->default('0');
			$table->text('experiences')->nullable();
			$table->string('subject', 255)->nullable();
			$table->string('card_file_id', 255)->nullable();
			$table->integer('old_price')->nullable();
			$table->decimal('corp_price', 15,0)->nullable()->default('500');
			$table->integer('discount_percent')->nullable()->default('0');
			$table->tinyInteger('is_vip')->nullable()->default('0');
			$table->tinyInteger('spc_user')->nullable()->default('0');
			$table->tinyInteger('is_private')->default('0');
			$table->tinyInteger('videocall')->nullable()->default('0');
			$table->string('videoDescription', 500);
			$table->tinyInteger('listing')->nullable()->default('1');
			$table->string('nezamCode', 255)->nullable();
			$table->tinyInteger('package_enabled')->nullable()->default('1');
			$table->tinyInteger('chat_consulting')->nullable()->default('0');
			$table->integer('temporary_banned_times')->nullable()->default('0');
			$table->string('chat_consulting_description', 500)->nullable();
			$table->integer('departmentID');
			$table->string('navid_net_number', 20)->nullable()->default('49187100');
			$table->timestamps();
			$table->tinyInteger('chat_enabled')->nullable()->default('1');
			$table->string('currency_code', 5);
			$table->bigInteger('immediatelyOffWork')->default('0');
			$table->decimal('commisionRate', 15,0);
			$table->integer('reservasion_cancel_period')->nullable();
			$table->integer('minimum_instantaneous_communication_interval')->nullable();
			$table->tinyInteger('immediate_contact_enabled')->nullable()->default('1');
			$table->tinyInteger('call_enabled')->nullable()->default('1');
			$table->tinyInteger('video_enabled')->nullable()->default('1');
			$table->tinyInteger('reserve_enabled')->nullable()->default('1');
			$table->string('online_status')->nullable();
			$table->string('calender', 500);
			$table->decimal('chat_consulting_price', 15,0)->nullable()->default('0');
			$table->datetime('last_activated_at')->nullable();
			$table->integer('videoPrice')->nullable()->default('0');
			$table->string('shortBio', 500);
			$table->integer('userID');
			$table->string('profileImageID', 300);
			$table->text('bio');
			$table->string('metaData', 1000)->nullable();
			$table->string('name');
			$table->string('languages', 200);
			$table->string('family');
		});
	}

	public function down()
	{
		Schema::drop('con_experts');
	}
}