<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConHostsTable extends Migration {

	public function up()
	{
		Schema::create('con_hosts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('code', 191);
			$table->string('token', 300);
			$table->text('info');
			$table->enum('status', array('draft', 'active', 'suspended'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('con_hosts');
	}
}