<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email');
	protected $visible = array('email');

	public function has_order()
	{
		return $this->hasMany('Order');
	}

}