<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Venue extends Eloquent {

	protected $table = 'venue';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');
	protected $visible = array('name', 'description');

	public function has_user()
	{
		return $this->belongsToMany('User');
	}

	public function has_event()
	{
		return $this->hasMany('Event');
	}

}