<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ads_experiment', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('ads_procedure')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ads_price', function(Blueprint $table) {
			$table->foreign('experiment_id')->references('id')->on('ads_experiment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ads_experiment', function(Blueprint $table) {
			$table->dropForeign('ads_experiment_procedure_id_foreign');
		});
		Schema::table('ads_price', function(Blueprint $table) {
			$table->dropForeign('ads_price_experiment_id_foreign');
		});
	}
}