<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parent_id');
			$table->integer('predecessor_id');
			$table->integer('successor_id');
			$table->string('name', 20);
			$table->string('description');
			$table->date('startdate');
			$table->date('enddate');
			$table->enum('priority', array('L', 'M', 'H', 'E', 'N'));
			$table->enum('stauts', array('N', 'C', 'I', 'R', 'B', 'V', 'D', 'W'));
			$table->integer('tag')->unsigned();
			$table->date('duedate');
			$table->date('createddate');
			$table->integer('sprint_id')->unsigned();
			$table->integer('project_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}