<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWikiTable extends Migration {

	public function up()
	{
		Schema::create('wiki', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->unsigned();
			$table->string('attachment');
			$table->string('revision');
			$table->integer('user_id')->unsigned();
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('wiki');
	}
}