<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('repositories_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('repositories', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sprints', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('tag')->references('id')->on('tags')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('sprint_id')->references('id')->on('sprints')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('task_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('task_history', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('wiki', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('wiki', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_projects', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assigned_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assigned_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_repositories_id_foreign');
		});
		Schema::table('repositories', function(Blueprint $table) {
			$table->dropForeign('repositories_project_id_foreign');
		});
		Schema::table('sprints', function(Blueprint $table) {
			$table->dropForeign('sprints_project_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_tag_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_sprint_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_project_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_task_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_task_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_user_id_foreign');
		});
		Schema::table('task_history', function(Blueprint $table) {
			$table->dropForeign('task_history_user_id_foreign');
		});
		Schema::table('task_history', function(Blueprint $table) {
			$table->dropForeign('task_history_task_id_foreign');
		});
		Schema::table('wiki', function(Blueprint $table) {
			$table->dropForeign('wiki_project_id_foreign');
		});
		Schema::table('wiki', function(Blueprint $table) {
			$table->dropForeign('wiki_user_id_foreign');
		});
		Schema::table('users_projects', function(Blueprint $table) {
			$table->dropForeign('users_projects_user_id_foreign');
		});
		Schema::table('users_projects', function(Blueprint $table) {
			$table->dropForeign('users_projects_project_id_foreign');
		});
		Schema::table('assigned_roles', function(Blueprint $table) {
			$table->dropForeign('assigned_roles_role_id_foreign');
		});
		Schema::table('assigned_roles', function(Blueprint $table) {
			$table->dropForeign('assigned_roles_user_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
	}
}