<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('en_name', 255);
			$table->string('ar_name', 255);
			$table->text('en_description');
			$table->text('ar_description');
			$table->date('start_date');
			$table->text('end_date');
			$table->integer('store_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}