<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('mall_id')->references('id')->on('mall')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('store_category', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('store_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_mall_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_store_id_foreign');
		});
		Schema::table('store_category', function(Blueprint $table) {
			$table->dropForeign('store_category_store_id_foreign');
		});
		Schema::table('store_category', function(Blueprint $table) {
			$table->dropForeign('store_category_category_id_foreign');
		});
	}
}