<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_values', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_attribute_sets', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_attribute_sets', function(Blueprint $table) {
			$table->foreign('attribute_set_id')->references('id')->on('attribute_sets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_product_values', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_product_values', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('racks', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('attribute_set_id')->references('id')->on('attribute_sets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_store_id_foreign');
		});
		Schema::table('attribute_values', function(Blueprint $table) {
			$table->dropForeign('attribute_values_attribute_id_foreign');
		});
		Schema::table('attribute_attribute_sets', function(Blueprint $table) {
			$table->dropForeign('attribute_attribute_sets_attribute_id_foreign');
		});
		Schema::table('attribute_attribute_sets', function(Blueprint $table) {
			$table->dropForeign('attribute_attribute_sets_attribute_set_id_foreign');
		});
		Schema::table('attribute_product_values', function(Blueprint $table) {
			$table->dropForeign('attribute_product_values_product_id_foreign');
		});
		Schema::table('attribute_product_values', function(Blueprint $table) {
			$table->dropForeign('attribute_product_values_attribute_id_foreign');
		});
		Schema::table('racks', function(Blueprint $table) {
			$table->dropForeign('racks_warehouse_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_attribute_set_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_category_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_product_id_foreign');
		});
	}
}