<?php

namespace categories;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Categories extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function parent()
    {
        return $this->belongsTo('categories\Categories', 'parent_id');
    }

    public function product_categories()
    {
        return $this->hasMany('productCategories\ProductCategories', 'category_id');
    }

}