<?php

namespace warehouses;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Warehouses extends Model 
{

    protected $table = 'warehouses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function store()
    {
        return $this->belongsTo('stores\Stores', 'store_id');
    }

    public function racks()
    {
        return $this->hasMany('racks\Racks', 'warehouse_id');
    }

}