<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->string('name');
			$table->bigInteger('age');
			$table->integer('blood_type_id');
			$table->integer('bags_count');
			$table->string('hospital_name');
			$table->string('hospital_address')->nullable();
			$table->decimal('latitude', 10,8);
			$table->decimal('longitude', 11,8);
			$table->bigInteger('city_id');
			$table->string('phone_number');
			$table->longText('notes');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}