<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('destinations', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('destinations', function(Blueprint $table) {
			$table->foreign('airport_departure_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('destinations', function(Blueprint $table) {
			$table->foreign('airport_destination_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('winner_id')->references('id')->on('entries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entries', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entries', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entries', function(Blueprint $table) {
			$table->foreign('destination_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aids', function(Blueprint $table) {
			$table->foreign('entry_id')->references('id')->on('entries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aids', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('destination_id')->references('id')->on('destinations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('destinations', function(Blueprint $table) {
			$table->dropForeign('destinations_campaign_id_foreign');
		});
		Schema::table('destinations', function(Blueprint $table) {
			$table->dropForeign('destinations_airport_departure_id_foreign');
		});
		Schema::table('destinations', function(Blueprint $table) {
			$table->dropForeign('destinations_airport_destination_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_winner_id_foreign');
		});
		Schema::table('entries', function(Blueprint $table) {
			$table->dropForeign('entries_user_id_foreign');
		});
		Schema::table('entries', function(Blueprint $table) {
			$table->dropForeign('entries_campaign_id_foreign');
		});
		Schema::table('entries', function(Blueprint $table) {
			$table->dropForeign('entries_destination_id_foreign');
		});
		Schema::table('aids', function(Blueprint $table) {
			$table->dropForeign('aids_entry_id_foreign');
		});
		Schema::table('aids', function(Blueprint $table) {
			$table->dropForeign('aids_user_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_destination_id_foreign');
		});
	}
}