<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Aid extends Eloquent {

	protected $table = 'aids';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('id', 'entry_id', 'user_id', 'timestamps');

	public function entry()
	{
		return $this->belongsTo('Entry');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}