<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCombinationsTable extends Migration {

	public function up()
	{
		Schema::create('product_combinations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('combination_string');
			$table->string('sku');
			$table->string('Price');
			$table->string('unique_string_id');
			$table->integer('product_id')->unsigned();
			$table->string('available_stock');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_combinations');
	}
}