<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('timestamps', function(Blueprint $table) {
			$table->foreign('cam_id')->references('id')->on('cams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('statistics', function(Blueprint $table) {
			$table->foreign('cam_id')->references('id')->on('cams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('statistics', function(Blueprint $table) {
			$table->foreign('timestamp_id')->references('id')->on('timestamps')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cams', function(Blueprint $table) {
			$table->foreign('realm_id')->references('id')->on('realms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('statistics_archive', function(Blueprint $table) {
			$table->foreign('cam_id')->references('id')->on('cams')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('statistics_archive', function(Blueprint $table) {
			$table->foreign('timestamp_id')->references('id')->on('timestamps')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('timestamps', function(Blueprint $table) {
			$table->dropForeign('timestamps_cam_id_foreign');
		});
		Schema::table('statistics', function(Blueprint $table) {
			$table->dropForeign('statistics_cam_id_foreign');
		});
		Schema::table('statistics', function(Blueprint $table) {
			$table->dropForeign('statistics_timestamp_id_foreign');
		});
		Schema::table('cams', function(Blueprint $table) {
			$table->dropForeign('cams_realm_id_foreign');
		});
		Schema::table('statistics_archive', function(Blueprint $table) {
			$table->dropForeign('statistics_archive_cam_id_foreign');
		});
		Schema::table('statistics_archive', function(Blueprint $table) {
			$table->dropForeign('statistics_archive_timestamp_id_foreign');
		});
	}
}