<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBatchMenuAttributesTable extends Migration {

	public function up()
	{
		Schema::create('batch_menu_attributes', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->integer('batch_menu_id')->unsigned()->nullable()->index();
			$table->integer('menu_attribute_id')->unsigned()->nullable()->index();
			$table->string('value')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('batch_menu_attributes');
	}
}