<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomMenusTable extends Migration {

	public function up()
	{
		Schema::create('custom_menus', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('note')->nullable();
			$table->integer('tag_menu_id')->unsigned()->nullable()->index();
			$table->integer('order_menu_id')->unsigned()->nullable()->index();
			$table->integer('custom_type_id')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->integer('total_tag_ids')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('custom_menus');
	}
}