<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('localidades', function(Blueprint $table) {
			$table->foreign('id_provincia')->references('id_provincia')->on('provincias')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('provincias', function(Blueprint $table) {
			$table->foreign('id_pais')->references('id_pais')->on('paises')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('permisos_usuarios', function(Blueprint $table) {
			$table->foreign('id_usuario')->references('id_usuario')->on('usuarios')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permisos_usuarios', function(Blueprint $table) {
			$table->foreign('id_permiso')->references('id_permiso')->on('permisos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permisos_roles', function(Blueprint $table) {
			$table->foreign('id_rol')->references('id_rol')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permisos_roles', function(Blueprint $table) {
			$table->foreign('id_permiso')->references('id_permiso')->on('permisos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('localidades', function(Blueprint $table) {
			$table->dropForeign('localidades_id_provincia_foreign');
		});
		Schema::table('provincias', function(Blueprint $table) {
			$table->dropForeign('provincias_id_pais_foreign');
		});
		Schema::table('permisos_usuarios', function(Blueprint $table) {
			$table->dropForeign('permisos_usuarios_id_usuario_foreign');
		});
		Schema::table('permisos_usuarios', function(Blueprint $table) {
			$table->dropForeign('permisos_usuarios_id_permiso_foreign');
		});
		Schema::table('permisos_roles', function(Blueprint $table) {
			$table->dropForeign('permisos_roles_id_rol_foreign');
		});
		Schema::table('permisos_roles', function(Blueprint $table) {
			$table->dropForeign('permisos_roles_id_permiso_foreign');
		});
	}
}