<?php

namespace PWCSD\NemesiCMS\Admin\Hosting\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Domain extends Eloquent {

	protected $table = 'domains';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function emailServer()
	{
		return $this->hasOne('Server', 'email_server_id');
	}

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

}