<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects_branches', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects_branches', function(Blueprint $table) {
			$table->foreign('project_database_id')->references('id')->on('projects_databases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects_branches_commits', function(Blueprint $table) {
			$table->foreign('project_branch_id')->references('id')->on('projects_branches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects_releases', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('domains', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('domains', function(Blueprint $table) {
			$table->foreign('email_server_id')->references('id')->on('servers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects_databases', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('domains_subdomains', function(Blueprint $table) {
			$table->foreign('domain_id')->references('id')->on('domains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('domains_subdomains', function(Blueprint $table) {
			$table->foreign('database_server_id')->references('id')->on('servers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('domains_subdomains', function(Blueprint $table) {
			$table->foreign('web_server_id')->references('id')->on('servers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('domains_emails', function(Blueprint $table) {
			$table->foreign('domain_id')->references('id')->on('domains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_customer_id_foreign');
		});
		Schema::table('projects_branches', function(Blueprint $table) {
			$table->dropForeign('projects_branches_project_id_foreign');
		});
		Schema::table('projects_branches', function(Blueprint $table) {
			$table->dropForeign('projects_branches_project_database_id_foreign');
		});
		Schema::table('projects_branches_commits', function(Blueprint $table) {
			$table->dropForeign('projects_branches_commits_project_branch_id_foreign');
		});
		Schema::table('projects_releases', function(Blueprint $table) {
			$table->dropForeign('projects_releases_project_id_foreign');
		});
		Schema::table('domains', function(Blueprint $table) {
			$table->dropForeign('domains_customer_id_foreign');
		});
		Schema::table('domains', function(Blueprint $table) {
			$table->dropForeign('domains_email_server_id_foreign');
		});
		Schema::table('projects_databases', function(Blueprint $table) {
			$table->dropForeign('projects_databases_project_id_foreign');
		});
		Schema::table('domains_subdomains', function(Blueprint $table) {
			$table->dropForeign('domains_subdomains_domain_id_foreign');
		});
		Schema::table('domains_subdomains', function(Blueprint $table) {
			$table->dropForeign('domains_subdomains_database_server_id_foreign');
		});
		Schema::table('domains_subdomains', function(Blueprint $table) {
			$table->dropForeign('domains_subdomains_web_server_id_foreign');
		});
		Schema::table('domains_emails', function(Blueprint $table) {
			$table->dropForeign('domains_emails_domain_id_foreign');
		});
	}
}