<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('slug');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('created_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}